

'               Three demonstration programs for the picaxe 08M.
'                 "Games timer"- Quiz Master"- Simple Slots"   
'                        Combined input/output board. 


'---------- Turn power on then select game using the push buttons ------------
select_game:
if input1 = 1 then run_timer        '---- "Games Timer"  press left button.
if input2 = 1 then run_qmaster      '---- "Quiz Master"  press center button
if input4 = 1 then run_slots        '---- "Simple Slots" press right button
pause 10
goto select_game
'-----------------------------------------------------------------------------



'---------------- "Games Timer" program for the picaxe 08M -------------------
' "Games timer" will speed up the playing of board games in particular chess.
' Begin by using the push buttons to select either 10 / 20 / 30 second times.
' Left button for 10 sec / Center button for 20 sec / Right button for 30 sec.
' The timer will continue to cycle with a beep at the end of each time period.
' Timer progress is shown by the leds and the re-set button will zero the timer.
' Left led timer is running / Center led 8 sec remain / Right led 4 sec remain. 
' Finally the only way to stop the timer cycle is to turn the power switch off. 
'----------------------------------------------------------------------------- 
          

run_timer:
sound 0,(120,25)
'goto start_timer


start_timer:' -- buttons select the required time ----
if input1 = 1 then time_10
if input2 = 1 then time_20
if input4 = 1 then time_30
goto start_timer


time_10:'  ---- set-up 10 second timer - show right led ----
high 1
b4 = 50
goto beep_1


time_20:'  ---- set-up 20 second timer - show center led ----
high 2
b4 = 100
goto beep_1


time_30:'  ---- set-up 30 second timer - show left led ----
high 4
b4 = 150
'goto beep_1


beep_1:'   ---- add beep and hold leds on for one second ----
sound 0,(120,25)
pause 1000
'goto main_timer


main_timer:' ---- timing loop and timer progress display ----
for b5 = b4 to 1 step -1
if pin3 = 1 then beep_2
low 1: low 2: low 4
if b5 > 40 then :let pins = 2 : endif
if b5 <40 and b5 > 20 then :let pins = 6 : endif
if b5 < 20 then :let pins = 22 : endif
pause 200
next b5
'goto beep_2


beep_2:'    ---- add beep at the end of each timing cycle ----
sound 0,(80,50)
goto main_timer


'----------------- "Quiz Master" program for the picaxe 08M ------------------
' Quiz control for three teams, showing which team presses their button first
' Team one left button / team two center button / team three right button..              
' Leds adjacent to the push buttons will light to indicate the winning team.
' In addition a differant beep will be produced to identify each winning team
' The winning led will remain on for three seconds before the program re-sets 
' The re-set push button can also be pressed to speed up the re-set process.
'-----------------------------------------------------------------------------

run_qmaster:
sound 0,(120,25)
'goto start_qmaster


start_qmaster:' ---- wait for the first push button press ----
input 1: input 2: input 4
if input1 = 1 then team_one
if input2 = 1 then team_two
if input4 = 1 then team_three
goto start_qmaster


team_one:'         ---- light/sound if team one is first ----
high 1
sound 0,(30,80)
goto end_qmaster


team_two:'         ---- light/sound if team two is first ---- 
high 2
sound 0,(90,80)
goto end_qmaster


team_three:'       ---- light/sound if team three is first ----
high 4
sound 0,(120,80)
goto end_qmaster


end_qmaster:'   ---- re-sets after 3 seconds or use push button ----
for b1 = 1 to 200
if pin3 = 1 then start_qmaster
pause 15
next b1
goto start_qmaster


'------------------- "Simple Slots" program for the picaxe 08M ---------------
'You now have your own Poker Machine or use to decide who will play a game first.
'Pressing a button (right,center or left) will randomly select a pattern of leds.
'The winning pattern is all three leds on - you will then hear the winning sound.  
'To get the next pattern - press the re-set button followed by any other button.
'Having only four possible led patterns a winning pattern should not take long.
'------------------------------------------------------------------------------


run_slots:
sound 0,(120,25)
'goto start_slots


start_slots:' ---- press any main button to run slots ----
input 1: input 2: input 4
random w0 :pause 10
if input1 = 1 or input2 = 1 or input4 = 1 then roll_number
goto start_slots


roll_number:' ---- random selection of led display ----
sound 0,(120,25)
low 1: low 2: low 4
if b1 < 64 then show_left
if b1 < 128 then show_center
if b1 < 194 then show_right
'if b1 < 255 then show_all


'show_all:'   ---- three leds and sound -- you win ---- 
let pins = 22 
for b3 = 60 to 100 step 4
sound 0,(b3,20)
next b3
goto end_game'


show_right:'  ---- turn on right led ----
let pins = 16
goto end_game


show_center:' ---- turn on center led ----
let pins = 4
goto end_game


show_left:'   ---- turn on left led ----
let pins = 2
'goto end_game


end_game:'    ---- press re-set to return to the start ----
if pin3 = 1 then start_slots
pause 15
goto end_game


